<?php
// ################################################################################################################
// ## Thumbnail Control Engine Files ##############################################################################
require_once('thumb_engine.php');

// ################################################################################################################
// ## Thumbnail List Process for List #############################################################################
// ################################################################################################################
function categoryCheck($realCT,$tempCT){
	global $database, $owner;
	$ct_cnt = count($tempCT);
	for($i=0;$i<$ct_cnt;$i++){
		$pid = DBQuery::queryAll("SELECT id FROM {$database['prefix']}Categories WHERE owner = {$owner} AND parent = {$tempCT[$i]}");
		if($pid == NULL){
			if($realCT==$tempCT[$i]) return true;	
		}else {
			foreach($pid as $item){
				if($realCT==$tempCT[$i] || $realCT == $item['id']) return true;
			}
		}
	}
}

function showThumbListView() {
	global $database, $owner, $configVal, $hostURL, $blogURL, $folderURL, $service, $skinSetting, $pluginURL, $service, $list, $view, $category, $paging, $skin, $blog, $suri;
	requireComponent('Tattertools.Model.Paging');
	requireComponent('Tattertools.Model.Statistics');
	requireComponent('Tattertools.Function.misc');
	$data = misc::fetchConfigVal($configVal);

	$categories = getCategoriesSET();
	$ctArray = array(); $setCategory = array();
	foreach($categories as $category1){
		foreach($category1['children'] as $category2) array_push($ctArray, $category2['children']);
		array_push($ctArray, $category1['children']);
	}
	for($i=0; $i<=count($ctArray); $i++){
		if($data['c'.$i])
		array_push($setCategory, $data['c'.$i]);
	}
	if($data['call']){
			$setCategory = array();
			$categories = getCategoriesSET();
			$tree = getCategoryArray($categories);
			foreach($tree['children'] as $child){
				array_push($setCategory, $child['id']);
				foreach($child['children'] as $leaf){
					array_push($setCategory, $leaf['id']);
				}
			}
	}
	if(isset($list)){
	 if((categoryCheck($category, $setCategory)==true) 
		|| (($data['call'])?$suri['directive']=="/category":"" ) 
		|| (($data['p1'])?$suri['directive']=="/archive":"" ) 
		|| (($data['p2'])?$suri['directive']=="/search":"" ) 
		|| (($data['p3'])?$suri['directive']=="/tag":"" ) 
		){

		if($_GET['pagenum']==""){ 
			$pagenum=1;
		}else{
			$pagenum=$_GET['pagenum'];
		}

		$data['totalview'] = $data['maxX']*$data['maxY'];
		$start = $data['totalview']*($pagenum-1);
		$limit = " limit {$start}, {$data['totalview']} ";
		if($category > 0){
			$subCT = DBQuery::queryColumn("SELECT id FROM {$database['prefix']}Categories WHERE owner = $owner AND parent = $category");
			array_push($subCT, $category);
			$realCT = implode(',',$subCT);
			$checkSuri = " AND e.category in ({$realCT}) ";
		}

		if($data['call'] && $category==0){
			$ctArray = array();
			$categories = getCategoriesSET();
			$tree = getCategoryArray($categories);
			foreach($tree['children'] as $child){
				array_push($ctArray, $child['id']);
				foreach($child['children'] as $leaf){
					array_push($ctArray, $leaf['id']);
				}
			}
			array_push($ctArray, $category);
			$realCT = implode(',',$ctArray);
			$checkSuri = " AND e.category in ({$realCT}) ";
		}

		if($data['p1'] && $suri['directive'] == '/archive' && $suri['value'] == ''){
			$tyear		= date("Y");
			$tmonth		= date("m");
			$lastDay	= date('t',mktime(0,0,0,$tmonth,1,$tyear));
			$dateStart	= strtotime("{$tyear}-{$tmonth}-01 00:00:00");
			$dateEnd	= strtotime("{$tyear}-{$tmonth}-{$lastDay} 23:59:59");
			$checkSuri	= " AND (e.published >= ".$dateStart." AND e.published <= ".$dateEnd.") ";
		}else if($data['p1'] && $suri['directive'] == '/archive' && $suri['value'] != ''){
			$xyear	= substr($suri['value'], 0, 4);
			$xmonth = substr($suri['value'], 4, 2);
			$xday	= substr($suri['value'], 6, 2);
			if(!$xmonth){
				$dateStart	= strtotime("{$xyear}-01-01 00:00:00");
				$dateEnd	= strtotime("{$xyear}-12-31 23:59:59");
			}else{
				$lastDay	= date('t',mktime(0,0,0,$xmonth,1,$xyear));
				$dateStart	= strtotime("{$xyear}-{$xmonth}-01 00:00:00");
				$dateEnd	= strtotime("{$xyear}-{$xmonth}-{$lastDay} 23:59:59");
				if($xday){
					$dateStart	= strtotime("{$xyear}-{$xmonth}-{$xday} 00:00:00");
					$dateEnd	= strtotime("{$xyear}-{$xmonth}-{$xday} 23:59:59");
				}
			}
			$checkSuri = " AND (e.published >= ".$dateStart." AND e.published <= ".$dateEnd.") ";		
		}
		
		if($data['p2'] && ($suri['directive'] == '/search') && $suri['value'] == ''){
			$checkSuri = "";
		}else if($data['p2'] && ($suri['directive'] == '/search') && $suri['value'] != ''){
			$search = escapeMysqlSearchString($suri['value']);
			$checkSuri = " AND (e.title LIKE '%$search%' OR e.content LIKE '%$search%') ";
		}
		if($data['fList'] && !$data['f5']){
				$attachCheckA = " , {$database['prefix']}Attachments a ";
				$attachCheckB = " AND a.parent = e.id AND (".(($data['f1'])?"a.name like '%.jpg' OR":"").(($data['f2'])?" a.name like '%.jpeg' OR":"").(($data['f3'])?" a.name like '%.gif' OR":"").(($data['f4'])?" a.name like '%.png'":"")." '') GROUP BY a.parent";
		}
		$visibility = doesHaveOwnership()?'':' AND e.visibility > 0 ';
		$data['listcount'] = count(DBQuery::queryAll("SELECT * FROM {$database['prefix']}Entries e {$attachCheckA} WHERE e.owner = {$owner} AND e.category >= 0 {$visibility} {$checkSuri} {$attachCheckB}"));
		$result1 = mysql_query("SELECT e.id, e.title, e.slogan, e.published, e.comments, e.visibility, e.content FROM {$database['prefix']}Entries e {$attachCheckA} WHERE e.owner = {$owner} AND e.category >= 0 {$visibility} {$checkSuri} {$attachCheckB} ORDER BY e.published DESC {$limit}");
		$paging_sql = "SELECT * FROM {$database['prefix']}Entries e {$attachCheckA} WHERE e.owner = {$owner} AND e.category >= 0 {$visibility} {$checkSuri} {$attachCheckB} ORDER BY e.published DESC";
		
		if($data['p3'] && ($suri['directive'] == '/tag') && $suri['value'] != ''){
			$checkSuri = "";
			$visibility = doesHaveOwnership()?'':' AND e.visibility > 0 ';
			$data['listcount'] = count(DBQuery::queryAll("SELECT * FROM {$database['prefix']}Tags t, {$database['prefix']}TagRelations r, {$database['prefix']}Entries e {$attachCheckA} WHERE r.entry = e.id {$visibility} AND e.category > 0 AND t.id = r.tag AND r.owner = {$owner} AND e.owner = {$owner} AND t.name = '" . mysql_real_escape_string($suri['value']) . "' {$attachCheckB}"));
			$result1 = mysql_query("SELECT e.id, e.title, e.slogan, e.published, e.comments, e.visibility, e.content FROM {$database['prefix']}Tags t, {$database['prefix']}TagRelations r, {$database['prefix']}Entries e {$attachCheckA} WHERE r.entry = e.id {$visibility} AND e.category > 0 AND t.id = r.tag AND r.owner = {$owner} AND e.owner = {$owner} AND t.name = '" . mysql_real_escape_string($suri['value']) . "' {$attachCheckB} ORDER BY published DESC {$limit}");
			$paging_sql = "SELECT e.id, e.title, e.slogan, e.published, e.comments FROM {$database['prefix']}Tags t, {$database['prefix']}TagRelations r, {$database['prefix']}Entries e {$attachCheckA} WHERE r.entry = e.id {$visibility} AND e.category > 0 AND t.id = r.tag AND r.owner = {$owner} AND e.owner = {$owner} AND t.name = '" . mysql_real_escape_string($suri['value']) . "' {$attachCheckB}";
		}
		
		list($temp, $temp_paging) = Statistics::fetchWithPaging($paging_sql, $pagenum, $data['totalview'], "$folderURL/{$suri['value']}",'?pagenum=');

		if(!isset($data['header'])){
			$thumb_list  = "<div class=\"list\"><h3><span class=\"keycolor\">'[##_list_conform_##]'</span>에 해당되는 글 [##_list_count_##]건 </h3>";
		}else{
			$thumb_list  = $data['header'];
		}
		$thumb_list .= "\t\t<div id=\"thumb_main\"><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>\n";
		$thumb_cnt = 0;
		while(list($eid, $title, $slogan, $date, $comment_cnt, $visibility, $content) = mysql_fetch_array($result1)) {
			$f_name = DBQuery::queryCell("SELECT name FROM {$database['prefix']}Attachments WHERE owner = {$owner} AND parent = {$eid} ORDER BY attached ASC");
			if($f_name || $data['urlimg']==1){
				$filename=(ereg("([0-9]*)",$f_name,$matches))?$matches[0]:NULL;
				$targetfile = ROOT."/thumbnail/list/{$owner}/{$filename}".".thumb";
				$sourcefile = ROOT."/attach/{$owner}/{$f_name}";
				$img_tag = get_thumbTag($eid, $filename, $content, &$sourcefile, $data['width'], $data['height'], $targetfile, $mode="thumb", $data['resize'], $data['quality'], $data['urlimg']);
				$img_tag[2] = $service['path'].str_replace(ROOT, "", $img_tag[2]);
				if(!getAttachCheck_Thumb(misc::getFileExtension($img_tag[2])) || ($visibility == 1 && !doesHaveOwnership())) $img_tag = array($data['width'], $data['height'], "{$pluginURL}/no_screenshot.jpg");
			}else{
				$img_tag = array($data['width'], $data['height'], "{$pluginURL}/no_screenshot.jpg");
			}

			$lightbox_src = "{$service['path']}/attach/$owner/{$f_name}";
			$permalink=($blog['useSlogan']?"{$blogURL}/entry/{$slogan}":$blogURL."/".$eid);

			if($data['comment'] == 1){
				(($comment_cnt == 0)? $entry_comment=" <span class=\"cnt\"></span>":$entry_comment=" <span class=\"cnt\">({$comment_cnt})</span>");
			}

			if($data['title'] == 1){
				$entry_title = "<div class=\"thumb_title\"><a href=\"{$permalink}\">".htmlspecialchars(UTF8::lessenAsEm($title, $data['title_length']))."</a>{$entry_comment}</div>";
			}

			if($data['date'] == 1){
				$entry_date = "<div><span class=\"date\">".Timestamp::format3($date)."</span></div>";
			}

			if(($thumb_cnt % $data['maxX']) == ($data['maxX']-1)){
				$line_chk = ($thumb_cnt == ($data['totalview']-1))?"\t\t</tr>\n":"\t\t</tr>\n\t\t<tr>\n";
			}else{$line_chk = "";}

			if($visibility == 1 && !doesHaveOwnership()) $title = "보호되어 있는 글입니다.";

			if($data['lightbox'] == 1 && $visibility != 1 && getAttachCheck_Thumb(misc::getFileExtension($sourcefile))){
				$thumb_list .= "\t\t<td valign=\"{$data['valign']}\" align=\"{$data['align']}\"><div class=\"thumb_item\"><a href=\"{$lightbox_src}\" rel=\"lightbox\" title=\"{$title}\"><img src=\"{$img_tag[2]}\" width=\"$img_tag[0]\" height=\"$img_tag[1]\" border=\"0\" alt=\"{$title}\" class=\"thumb_border\" /></a>{$entry_title}{$entry_date}</div></td>\n{$line_chk}";
			}else{
				$thumb_list .= "\t\t<td valign=\"{$data['valign']}\" align=\"{$data['align']}\"><div class=\"thumb_item\"><a href=\"{$permalink}\" title=\"{$title}\"><img src=\"{$img_tag[2]}\" width=\"$img_tag[0]\" height=\"$img_tag[1]\" border=\"0\" alt=\"{$title}\" class=\"thumb_border\" /></a>{$entry_title}{$entry_date}</div></td>\n{$line_chk}";
			}
			$thumb_cnt++;
		}
		
		if ($thumb_cnt<($data['totalview']-1)) {
			for($i=($thumb_cnt % $data['maxX']==0)? $data['maxX']+1:($thumb_cnt % $data['maxX']);$i < $data['maxX'];$i++){
				$thumb_list .= "\t\t<td>&nbsp;</td>\n";
			}
			$thumb_list .= "\t\t</tr>\n";
		}
		
		$target = $thumb_list."\t\t</table></div><div class=\"divide\"></div>\n";

		if(!isset($data['footer'])){
			$target .= "</div>";
		}else{
			$target .= $data['footer'];
		}

		misc::dress('rplist', "", $view);
		misc::dress('article_rep', "", $view);
		misc::dress('list_conform', htmlspecialchars($list['title']), $target);
		misc::dress('list_count', $data['listcount'], $target);
		if(isset($paging)) misc::dress('paging',Paging::getPagingView($temp_paging,$skin->paging,$skin->pagingItem),$view);;
	 }else{
		$listView = $skin->list;
		$itemsView = '';
		foreach ($list['items'] as $item) {	
			$itemsView .= str_replace(
				array(
					'[##_list_rep_regdate_##]',
					'[##_list_rep_link_##]',
					'[##_list_rep_title_##]',
					'[##_list_rep_rp_cnt_##]'
				),
				array(
					fireEvent('ViewListDate', Timestamp::format3($item['published'])),
					"$blogURL/" . ($blog['useSlogan'] ? 'entry/' . encodeURL($item['slogan']) : $item['id']),
					htmlspecialchars(fireEvent('ViewListTitle', $item['title'])),
					($item['comments'] > 0) ? "({$item['comments']})" : ''
				),
				$skin->listItem
			);
		}
		misc::dress('list_rep', $itemsView, $listView);
		misc::dress('list_conform', fireEvent('ViewListHeadTitle', htmlspecialchars($list['title']) ), $listView);
		misc::dress('list_count', isset($list['count']) ? $list['count'] : '0', $listView);
		misc::dress('list', $listView, $view);
	 }
	}
	return $target;
}

// ################################################################################################################
// ## Thumbnail Recent View Process for Sidebar ###################################################################
// ################################################################################################################
function categoryCheck_recent($tempCT){
	global $database, $owner, $configVal;
	requireComponent('Tattertools.Function.misc');
	$data = misc::fetchConfigVal($configVal);
	$ct_cnt = count($tempCT);
	$arrayCT = array();
	for($i=0;$i<$ct_cnt;$i++){
		array_push($arrayCT, array('id'=>$tempCT[$i]));
	}
	foreach($arrayCT as $item){
		$pid = DBQuery::queryAll("SELECT * FROM {$database['prefix']}Categories WHERE owner = {$owner} AND parent = {$item['id']} ORDER BY id asc");
		if($j < 1){$sp="";}else{$sp=",";}
		$checkID .= $sp.$item['id'];
		if($pid){
			foreach($pid as $items){
				$checkID .= ",".$items['id'];
			}
		}
		$j++;
	}
	return $checkID;
}

function showSidebarPhotoView() {
	global $database, $owner, $configVal, $hostURL, $blogURL, $pluginURL, $service, $blog;
	requireComponent('Tattertools.Function.misc');
	$data = misc::fetchConfigVal($configVal);

	$categories = getCategoriesSET();
	$ctArray = array(); $setCategory = array();
	foreach($categories as $category1){
		foreach($category1['children'] as $category2) array_push($ctArray, $category2['children']);
		array_push($ctArray, $category1['children']);
	}
	for($i=0; $i<=count($ctArray); $i++){
		if($data['c'.$i])
		array_push($setCategory, $data['c'.$i]);
	}

	if($data['call']){
			$setCategory = array();
			$categories = getCategoriesSET();
			$tree = getCategoryArray($categories);
			foreach($tree['children'] as $child){
				array_push($setCategory, $child['id']);
				foreach($child['children'] as $leaf){
					array_push($setCategory, $leaf['id']);
				}
			}
	}

	$data['category'] = categoryCheck_recent($setCategory);
	$data['category'] = ($data['category'])?" AND e.category in ({$data['category']}) ":"";

	switch($data['sb_loading']){
		case 1:$thumb_load = "e.published DESC";break;
		case 2:$thumb_load = "rand()";break;
		case 3:$thumb_load = "e.comments DESC";break;
		default:return false;
	}
	// Thumbnail control process ######################################################################################
	$data['totalview'] = $data['sb_maxX']*$data['sb_maxY'];
	$limit = " limit {$data['totalview']} ";

	if($data['fSide']){
		if(!$data['f5']){
			$attachCheckA = " , {$database['prefix']}Attachments a ";
			$attachCheckB = " AND a.parent = e.id AND (".(($data['f1'])?"a.name like '%.jpg' OR":"").(($data['f2'])?" a.name like '%.jpeg' OR":"").(($data['f3'])?" a.name like '%.gif' OR":"").(($data['f4'])?" a.name like '%.png'":"")." '') GROUP BY a.parent";
		}
	}
	$visibility = doesHaveOwnership()?'':' AND e.visibility > 0';
	$result1 = mysql_query("SELECT e.id, e.title, e.slogan, e.published, e.comments, e.visibility, e.content FROM {$database['prefix']}Entries e {$attachCheckA} WHERE e.owner = {$owner} AND e.category >= 0 {$visibility} {$data['category']} {$attachCheckB} ORDER BY {$thumb_load} {$limit}");

	if(!isset($data['sb_header'])){
		$thumb_list  = "<div class=\"sidebar_photos\"><h3>sidebar photos</h3>";
	}else{
		$thumb_list  = $data['sb_header'];
	}

	$thumb_list .= "\t\t<div id=\"sidebarphotos_main\">\n\t\t<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>\n";
	$thumb_cnt = 0;
	while(list($eid, $title, $slogan, $date, $comment_cnt, $visibility, $content) = mysql_fetch_array($result1)) {
		$attach_load = ($data['sb_loading']==2)?" rand() ":" attached ";
		$f_name = DBQuery::queryCell("SELECT name FROM {$database['prefix']}Attachments WHERE owner = {$owner} AND parent = {$eid} ORDER BY {$attach_load} ASC");
		if($f_name || $data['urlimg']==1){
			$filename=(ereg("([0-9]*)",$f_name,$matches))?$matches[0]:NULL;
			$targetfile = ROOT."/thumbnail/recentphoto/{$owner}/{$filename}".".thumb";
			$sourcefile = ROOT."/attach/$owner/{$f_name}";
			$img_tag = get_thumbTag($eid, $filename, $content, &$sourcefile, $data['sb_width'], $data['sb_height'], $targetfile, $mode="recent", $data['sb_resize'], $data['quality'], $data['urlimg']);
			$img_tag[2] = $service['path'].str_replace(ROOT, "", $img_tag[2]);
			if(!getAttachCheck_Thumb(misc::getFileExtension($img_tag[2])) || ($visibility == 1 && !doesHaveOwnership())) $img_tag = array($data['sb_width'], $data['sb_height'], "{$pluginURL}/no_screenshot.jpg");
		}else{
			$img_tag = array($data['sb_width'], $data['sb_height'], "{$pluginURL}/no_screenshot.jpg");
		}

		$lightbox_src = "{$service['path']}/attach/$owner/{$f_name}";
		$permalink = ($blog['useSlogan']?"{$blogURL}/entry/{$slogan}":$blogURL."/".$eid);
		if($data['tempurl']){
			$permalink = $data['tempurl']."/".$eid;
		}

		if($data['sb_comment'] == 1){
			(($comment_cnt == 0)? $entry_comment="":$entry_comment=" <span class=\"cnt\">({$comment_cnt})</span>");
		}

		if($data['sb_title'] == 1){
			$entry_title = "<div class=\"thumb_title\"><a href=\"{$permalink}\">".htmlspecialchars(UTF8::lessenAsEm($title, $data['sb_title_length']))."</a>{$entry_comment}</div>";
		}

		if($data['sb_date'] == 1){
			$entry_date = "<div><span class=\"date\">".Timestamp::format3($date)."</span></div>";
		}
		
		if(($thumb_cnt % $data['sb_maxX']) == ($data['sb_maxX']-1)){
			$line_chk = ($thumb_cnt == ($data['totalview']-1))?"\t\t</tr>\n":"\t\t</tr>\n\t\t<tr>\n";
		}else{$line_chk = "";}

		if($visibility == 1 && !doesHaveOwnership()) $title = "보호되어 있는 글입니다.";

		if($data['sb_lightbox'] == 1 && $visibility != 1 && getAttachCheck_Thumb(misc::getFileExtension($sourcefile))){
			$thumb_list .= "\t\t<td valign=\"{$data['sb_valign']}\" align=\"{$data['sb_align']}\"><div class=\"thumb_item\"><a href=\"{$lightbox_src}\" rel=\"lightbox\" title=\"{$title}\"><img src=\"{$img_tag[2]}\" width=\"$img_tag[0]\" height=\"$img_tag[1]\" border=\"0\" alt=\"{$title}\" class=\"thumb_border\" /></a>{$entry_title}{$entry_date}</div></td>\n{$line_chk}";
		}else{
			$thumb_list .= "\t\t<td valign=\"{$data['sb_valign']}\" align=\"{$data['sb_align']}\"><div class=\"thumb_item\"><a href=\"{$permalink}\" title=\"{$title}\"><img src=\"{$img_tag[2]}\" width=\"$img_tag[0]\" height=\"$img_tag[1]\" border=\"0\" alt=\"{$title}\" class=\"thumb_border\" /></a>{$entry_title}{$entry_date}</div></td>\n{$line_chk}";
		}
		$thumb_cnt++;
	}
	if ($thumb_cnt<($data['totalview']-1)) {
		for($i=($thumb_cnt % $data['sb_maxX']==0)? $data['sb_maxX']+1:($thumb_cnt % $data['sb_maxX']);$i < $data['sb_maxX'];$i++){
			$thumb_list .= "\t\t<td>&nbsp;</td>\n";
		}
		$thumb_list .= "\t\t</tr>\n";
	}
	$target = $thumb_list."\t\t</table>\n\t\t</div>\n";

	if(!isset($data['sb_footer'])){
		$target .= "</div>";
	}else{
		$target .= $data['sb_footer'];
	}

	return $target;
}

// ################################################################################################################
// ## Thumbnail List & Sidebar Setting ############################################################################
// ################################################################################################################
function showThumbStyleScript($target){
	global $configVal;
	requireComponent('Tattertools.Function.misc');
	$data = misc::fetchConfigVal($configVal);
	$data['bordercolor'] = (strpos($data['bordercolor'], "#")===0)?$data['bordercolor']:"#".$data['bordercolor'];
	ob_start();
?>
<style type="text/css">
	/* Thumbnail List css setting for List */
	#thumb_main{margin:<?=$data['mainmargin'];?>;}
	#thumb_main .thumb_item{margin:<?=$data['itemmargin'];?>;text-align:<?=$data['align'];?>;}
	#thumb_main .thumb_border{margin:<?=$data['imagemargin'];?>;border:<?=$data['bordersize'];?> solid <?=$data['bordercolor'];?>;}
	#thumb_main .thumb_title a {font:<?=$data['titlesize'];?> <?=$data['titlefont'];?> !important;color:<?=$data['titlecolor'];?> !important;}
	#thumb_main .thumb_title .cnt {font:<?=$data['titlesize'];?> <?=$data['titlefont'];?> !important;color:<?=$data['titlecolor'];?> !important;}
	#thumb_main .date {font:<?=$data['titlesize'];?> <?=$data['titlefont'];?> !important;color:<?=$data['titlecolor'];?> !important;}

	/* Thumbnail Sidebar css setting for Sidebar */
	#sidebarphotos_main{margin:<?=$data['sb_mainmargin'];?>;}
	#sidebarphotos_main .thumb_item{margin:<?=$data['sb_itemmargin'];?>;text-align:<?=$data['sb_align'];?>;}
	#sidebarphotos_main .thumb_border{margin:0px 0px 0px 0px;border:<?=$data['sb_bordersize'];?> solid <?=$data['sb_bordercolor'];?>;}
	#sidebarphotos_main .thumb_title a {font:<?=$data['sb_titlesize'];?> <?=$data['sb_titlefont'];?> !important;color:<?=$data['sb_titlecolor'];?> !important;}
	#sidebarphotos_main .thumb_title .cnt {font:<?=$data['sb_titlesize'];?> <?=$data['sb_titlefont'];?> !important;color:<?=$data['sb_titlecolor'];?> !important;}
	#sidebarphotos_main .date {font:<?=$data['sb_titlesize'];?> <?=$data['sb_titlefont'];?> !important;color:<?=$data['sb_titlecolor'];?> !important;}
</style>
<!-- 
	J. Parker Thumbnail List/Sidebar View Plugin v3.5(2007/01/04) for Tattertools v1.1.* - http://www.create74.com
	DQ'Thumb Engine ver 2.0 R5.0306 for developer - http://www.dqstyle.com 
-->
<?
	$target .= ob_get_contents();
	ob_end_clean();
	return $target;
}

function getAttachCheck_Thumb($ext){
	$attachArray = array('jpg','jpeg','png','gif','thumb');
	foreach ($attachArray as $item){
		if($item == $ext) return true;
	}
}

function getCategoryName($id) {
	global $database, $owner;
	if (!Validator::number($id, 1))
		return null;
	return DBQuery::queryCell("SELECT name FROM {$database['prefix']}Categories WHERE owner = {$owner} AND id = {$id}");
}

function getCategoryArray($categories) {
	$tree = array('id'=>'','label'=>'','value'=>'','link'=>'','children'=>array());
	foreach($categories as $category1){
		$children=array();
		foreach($category1['children'] as $category2){
			array_push($children,array('id'=>$category2['id'],'label'=>$category2['name'],'value'=>(doesHaveOwnership()?$category2['entriesInLogin']:$category2['entries']),'link'=>"$blogURL/category/".encodeURL($category2['label']),'children'=>array()));
		}
		array_push($tree['children'],array('id'=>$category1['id'],'label'=>$category1['name'],'value'=>(doesHaveOwnership()?$category1['entriesInLogin']:$category1['entries']),'link'=>"$blogURL/category/".encodeURL($category1['label']),'children'=>$children));
	}
	return $tree;
}

function getCategoriesThumbnail() {
	global $owner, $blogURL;
	$categories = getCategoriesSET();
	$tree = getCategoryArray($categories);
	foreach($tree['children'] as $child){
	$cntA++;
	$cntB='';
	$cntC++;
	if(count($child['children'])){$br1 = "<br>";}else{$br1="";}
	$manifest .= '<op name="c'.$cntA.'" value="'.$child['id'].'"><![CDATA[<b><font color="#8D4143">'.htmlspecialchars($child['label']).'</font></b>'.$br1.']]></op>'.CRLF;
		$ctB = "";
		foreach($child['children'] as $leaf){
			$cntA++;
			$cntB++;
			if($cntB == count($child['children'])){$br2 = "<br>";}else{$br2="";}
			if((count($categories) == $cntC) && ($cntB == count($child['children']))) $br2="";
			$manifest .= '<op name="c'.$cntA.'" value="'.$leaf['id'].'"><![CDATA[<font color="#777777">'.htmlspecialchars($leaf['label']).'</font>'.$br2.']]></op>'.CRLF;
		}
	}
	return $manifest;
}

function getCategoriesSET() {
	global $database, $owner;
	$rows = DBQuery::queryAll("SELECT * FROM {$database['prefix']}Categories WHERE owner = $owner AND id > 0 ORDER BY parent, priority");
	$categories = array();
	foreach ($rows as $category) {
		if ($category['parent'] == null) {
			$category['children'] = array();
			$categories[$category['id']] = $category;
		} else if (isset($categories[$category['parent']]))
			array_push($categories[$category['parent']]['children'], $category);
	}
	return $categories;
}

function CFG_ThumbnailSet($plugin){
	global $owner, $configVal;
	requireComponent('Tattertools.Function.misc');
	$data = misc::fetchConfigVal($configVal);
	$setCategory = array();
	for($i=0; $i <= count($data); $i++){
		if($data['c'.$i])
		array_push($setCategory, getCategoryName($data['c'.$i]));
	}
	$manifest = NULL;
	$manifest .= '<?xml version="1.0" encoding="utf-8"?>'.CRLF;
	$manifest .= '<config dataValHandler="ThumbnailDataSet">'.CRLF;
	$manifest .= '	<window width="500" height="700" />'.CRLF;
	$manifest .= '	<fieldset legend="썸네일 카테고리 선택" >'.CRLF;
	$manifest .= '		<field title="　" name="category" type="checkbox" titledirection="bk">'.CRLF;
	$manifest .= '			<op name="call" value="1"><![CDATA[<b><font color="blue">All Category</font></b><br>]]></op>'.CRLF;
	$manifest .=			getCategoriesThumbnail();
	$manifest .= '			<caption><![CDATA[<b>tip:</b> <b><u><font color="blue">All Category</font></u></b> 선택시 <font color="red"><u>다른 카테고리</u></font>는 선택할수 없습니다.<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;말그대로 모든 카테고리 리스트를 썸네일 이미지로 보여집니다.<br><b>tip:</b> 썸네일 이미지를 적용할 카테고리를 체크하세요.<br><b>tip:</b> <b><font color="#8D4143">진한 빨간색</font></b>이 상위카테고리 입니다. 상위 카테고리만 선택을 해도 하위 카테고리 모두 적용됩니다. 또한, 하위 카테고리만 개별 선택해도 됩니다.<br><fieldset><legend><font color="red"><b>코드 추가</b></font></legend>\'<u>(설치Path)/blog/category/index.php</u>\'파일에서 \'<b>_t3_</b>\'를 검색하여 다음줄 빈공간에 <b>handleTags($view);</b> 코드 추가. 단, 개발버젼(원본)의 경우(설치Path) \'<u>/lib/piece/blog/list.php</u>\' 첫번째줄 빈공간에 <b>handleTags($view);</b> 코드 추가.</fieldset>]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '	</fieldset>'.CRLF;
	$manifest .= '	<fieldset legend="썸네일 리스트 적용 추가범위 선택" >'.CRLF;
	$manifest .= '		<field title=" " name="photoblog" type="checkbox" titledirection="bk">'.CRLF;
	$manifest .= '			<op name="p1" value="1"><![CDATA[<b><font color="green">Archive List</font></b>]]></op>'.CRLF;
	$manifest .= '			<op name="p2" value="1"><![CDATA[<b><font color="green">Search List</font></b>]]></op>'.CRLF;
	$manifest .= '			<op name="p3" value="1"><![CDATA[<b><font color="green">Tag List</font></b>]]></op>'.CRLF;
	$manifest .= '			<caption><![CDATA[<b>tip:</b> <b><u><font color="blue">All Category</font></u></b> 기본 선택시 함께 사용할 수 있습니다.<br><b>tip:</b> 사용하는 블로그가 포토 전용인 경우 권장합니다.(<u><font color="red">포토블로그 강추</font></u>)<br><fieldset><legend><font color="red"><b>코드 추가</b></font></legend>\'<u>(설치Path)/blog/archive/index.php</u>\'<br>\'<u>(설치Path)/blog/archive/item.php</u>\'<br>\'<u>(설치Path)/blog/search/index.php</u>\'<br>\'<u>(설치Path)/blog/tag/index.php</u>\'<br>위 파일들에서 \'<b>_t3_</b>\'를 검색하여 다음줄 빈공간에 <b>handleTags($view);</b> 코드 추가. 단, 개발버젼(원본)의 경우(설치Path) \'<u>/lib/piece/blog/list.php</u>\' 첫번째줄 빈공간에 <b>handleTags($view);</b> 코드 추가.<br>(위 카테고리 사용시 추가했으면 안해도 됨)</fieldset>]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '	</fieldset>'.CRLF;
	$manifest .= '	<fieldset legend="썸네일 적용 파일 선택" >'.CRLF;
	$manifest .= '		<field title=" : 적용범위" name="attachCheckItem" type="checkbox" titledirection="bk">'.CRLF;
	$manifest .= '			<op name="fList" value="1" checked="checked"><![CDATA[<b><font color="blue">List</font></b>&nbsp;&nbsp; &nbsp;]]></op>'.CRLF;
	$manifest .= '			<op name="fSide" value="1" checked="checked"><![CDATA[<b><font color="blue">SideBar</font></b>]]></op>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" " name="thumbnailAttach" type="checkbox" titledirection="bk" >'.CRLF;
	$manifest .= '			<op name="f1" value="1" checked="checked"><![CDATA[<b><font color="green">.JPG</font></b>&nbsp;&nbsp;]]></op>'.CRLF;
	$manifest .= '			<op name="f2" value="1" checked="checked"><![CDATA[<b><font color="green">.JPEG</font></b>&nbsp;&nbsp;]]></op>'.CRLF;
	$manifest .= '			<op name="f3" value="1" checked="checked"><![CDATA[<b><font color="green">.GIF</font></b>&nbsp;&nbsp;]]></op>'.CRLF;
	$manifest .= '			<op name="f4" value="1" checked="checked"><![CDATA[<b><font color="green">.PNG</font></b>&nbsp;&nbsp;]]></op>'.CRLF;
	$manifest .= '			<op name="f5" value="1" checked="checked"><![CDATA[<b><font color="#D88787">ALL Files</font></b>]]></op>'.CRLF;
	$manifest .= '			<caption><![CDATA[<b>tip:</b> 각각의 파일을 선택 해제하면, 해제된 파일이 존재하는 포스트는 썸네일 목록에서 제외됩니다.<br><b>tip:</b> \'<b><font color="#D88787">ALL Files</font></b>\'를 선택하게 되면 썸네일 이미지로 변환 못시키는 파일과 포스트 내에 파일이 존재하지 않을때 <u>대체이미지</u>로 표시됩니다.]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 링크 이미지" name="urlimg" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="1" checked="checked">ON</op>'.CRLF;
	$manifest .= '			<op value="2">OFF</op>'.CRLF;
	$manifest .= '			<caption><![CDATA[<b>tip:</b> \'<b><font color=blue>&lt;img&gt;</font></b>\' 태그로 링크된 이미지를 썸네일화 시킵니다.]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '	</fieldset>'.CRLF;
	$manifest .= '	<fieldset legend="이미지 품질" >'.CRLF;
	$manifest .= '		<field title=" : 썸네일 이미지 품질(0~100)" name="quality" type="text" size="3" titledirection="bk" value="95" />'.CRLF;
	$manifest .= '	</fieldset>'.CRLF;
	$manifest .= '	<fieldset legend="리스트 설정" >'.CRLF;
	$manifest .= '		<field title=" : 썸네일 가로크기" name="width" type="text" size="3" titledirection="bk" value="75" />'.CRLF;
	$manifest .= '		<field title=" : 썸네일 세로크기" name="height" type="text" size="3" titledirection="bk" value="150" />'.CRLF;
	$manifest .= '		<field title=" : 표시될 썸네일 가로갯수" name="maxX" type="text" size="3" titledirection="bk" value="5" />'.CRLF;
	$manifest .= '		<field title=" : 표시될 썸네일 세로갯수" name="maxY" type="text" size="3" titledirection="bk" value="6" />'.CRLF;
	$manifest .= '		<field title=" : 리사이즈방식" name="resize" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="1">원본비율대칭</op>'.CRLF;
	$manifest .= '			<op value="2">비율유지안함</op>'.CRLF;
	$manifest .= '			<op value="3" checked="checked">원본비율+가운데자름</op>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 제목 표시하기" name="title" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="1" checked="checked">ON</op>'.CRLF;
	$manifest .= '			<op value="2">OFF</op>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 표시할 제목길이" name="title_length" type="text" size="3" titledirection="bk" value="7" />'.CRLF;
	$manifest .= '		<field title=" : 댓글수 표시하기" name="comment" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="1" checked="checked">ON</op>'.CRLF;
	$manifest .= '			<op value="2">OFF</op>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 날짜 표시하기" name="date" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="1" checked="checked">ON</op>'.CRLF;
	$manifest .= '			<op value="2">OFF</op>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : LightBox플러그인 기능 적용하기" name="lightbox" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="1">ON</op>'.CRLF;
	$manifest .= '			<op value="2" checked="checked">OFF</op>'.CRLF;
	$manifest .= '			<caption><![CDATA[<b><a href="http://moonmelody.com/tt/" target="_blank">치리님</a></b>의 LightBox플러그인이 설치되어 있으면 썸네일 클릭시 LightBox 형태로 원본이미지표시됨. (link : <a href="http://moonmelody.com/tt/entry/LightboxTTAZmanualNqna" target="_blank">Lightbox TT AZ</a>)]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '	</fieldset>'.CRLF;
	$manifest .= '	<fieldset legend="리스트 스타일(CSS) 설정" >'.CRLF;
	$manifest .= '		<field title=" : 가로 정렬" name="align" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="left">Left</op>'.CRLF;
	$manifest .= '			<op value="center" checked="checked">Center</op>'.CRLF;
	$manifest .= '			<op value="right">Right</op>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 세로 정렬" name="valign" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="top">Top</op>'.CRLF;
	$manifest .= '			<op value="middle">Middle</op>'.CRLF;
	$manifest .= '			<op value="bottom" checked="checked">Bottom</op>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 리스트 메인 바깥여백" name="mainmargin" type="text" size="20" titledirection="bk" value="20px 0px 0px 0px" >'.CRLF;
	$manifest .= '			<caption><![CDATA[<b>tip:</b> 20px 1px 2px 1px , [상px 우px 하px 좌px]]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 리스트 서브 바깥여백" name="itemmargin" type="text" size="20" titledirection="bk" value="0px 6px 10px 5px" >'.CRLF;
	$manifest .= '			<caption><![CDATA[<b>tip:</b> 20px 1px 2px 1px , [상px 우px 하px 좌px]]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 썸네일 이미지 바깥여백" name="imagemargin" type="text" size="20" titledirection="bk" value="0px 0px 5px 0px" >'.CRLF;
	$manifest .= '			<caption><![CDATA[<b>tip:</b> 20px 1px 2px 1px , [상px 우px 하px 좌px]]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 썸네일 이미지 테두리 사이즈" name="bordersize" type="text" size="4" titledirection="bk" value="4px" />'.CRLF;
	$manifest .= '		<field title=" : 썸네일 이미지 테두리색" name="bordercolor" type="text" size="8" titledirection="bk" value="#E7E7E7" >'.CRLF;
	$manifest .= '			<caption><![CDATA[<b>tip:</b> #D7SDFS or D7SDFS, #d7sdfs or d7sdfs]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 제목.댓글.날짜 글꼴" name="titlefont" type="text" size="10" titledirection="bk" value="dotum" />'.CRLF;
	$manifest .= '		<field title=" : 제목.댓글.날짜 크기" name="titlesize" type="text" size="10" titledirection="bk" value="11px" />'.CRLF;
	$manifest .= '		<field title=" : 제목.댓글.날짜 색상" name="titlecolor" type="text" size="10" titledirection="bk" value="#777777" >'.CRLF;
	$manifest .= '			<caption><![CDATA[<b>tip:</b> 글꼴 크기는 \'pt\', \'px\', \'em\'등 단위를 포함해야 함.]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '	</fieldset>'.CRLF;
	$manifest .= '	<fieldset legend="리스트 메인 HTML Hearder">'.CRLF;
	$manifest .= '		<field title="* 사용중인 skin.html 참고" name="header" cols="51" rows="6"  type="textarea" titledirection="bk" ><![CDATA[<div class="list">'.CRLF;
	$manifest .= '<h3><span class="keycolor">\'[##_list_conform_##]\'</span>에 해당되는 글 [##_list_count_##]건 </h3>]]></field>'.CRLF;
	$manifest .= '	</fieldset>'.CRLF;
	$manifest .= '	<fieldset legend="리스트 메인 HTML Footer">'.CRLF;
	$manifest .= '		<field title="* 사용중인 skin.html 참고" name="footer" cols="51" rows="6"  type="textarea" titledirection="bk" ><![CDATA[</div>]]>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '	</fieldset>'.CRLF;

	$manifest .= '	<fieldset legend="사이드바 썸네일 설정" >'.CRLF;
	$manifest .= '		<field title=" : 썸네일 가로크기" name="sb_width" type="text" size="3" titledirection="bk" value="37" />'.CRLF;
	$manifest .= '		<field title=" : 썸네일 세로크기" name="sb_height" type="text" size="3" titledirection="bk" value="37" />'.CRLF;
	$manifest .= '		<field title=" : 표시될 썸네일 가로갯수" name="sb_maxX" type="text" size="3" titledirection="bk" value="4" />'.CRLF;
	$manifest .= '		<field title=" : 표시될 썸네일 세로갯수" name="sb_maxY" type="text" size="3" titledirection="bk" value="2" />'.CRLF;
	$manifest .= '		<field title=" : 리사이즈방식" name="sb_resize" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="1">원본비율대칭</op>'.CRLF;
	$manifest .= '			<op value="2">비율유지안함</op>'.CRLF;
	$manifest .= '			<op value="3" checked="checked">원본비율+가운데자름</op>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 이미지 로딩방식" name="sb_loading" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="1">최근등록순</op>'.CRLF;
	$manifest .= '			<op value="2" checked="checked">랜덤</op>'.CRLF;
	$manifest .= '			<op value="3">댓글순</op>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 제목 표시하기" name="sb_title" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="1">ON</op>'.CRLF;
	$manifest .= '			<op value="2" checked="checked">OFF</op>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 표시할 제목길이" name="sb_title_length" type="text" size="3" titledirection="bk" value="7" />'.CRLF;
	$manifest .= '		<field title=" : 댓글수 표시하기" name="sb_comment" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="1">ON</op>'.CRLF;
	$manifest .= '			<op value="2" checked="checked">OFF</op>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 날짜 표시하기" name="sb_date" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="1">ON</op>'.CRLF;
	$manifest .= '			<op value="2" checked="checked">OFF</op>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : LightBox플러그인 기능 적용하기" name="sb_lightbox" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="1">ON</op>'.CRLF;
	$manifest .= '			<op value="2" checked="checked">OFF</op>'.CRLF;
	$manifest .= '			<caption><![CDATA[<b><a href="http://moonmelody.com/tt/" target="_blank">치리님</a></b>의 LightBox플러그인이 설치되어 있으면 썸네일 클릭시 LightBox 형태로 원본이미지표시됨. (link : <a href="http://moonmelody.com/tt/entry/LightboxTTAZmanualNqna" target="_blank">Lightbox TT AZ</a>)]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '	</fieldset>'.CRLF;
	$manifest .= '	<fieldset legend="사이드바 썸네일 스타일(CSS) 설정" >'.CRLF;
	$manifest .= '		<field title=" : 가로 정렬" name="sb_align" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="left">Left</op>'.CRLF;
	$manifest .= '			<op value="center" checked="checked">Center</op>'.CRLF;
	$manifest .= '			<op value="right">Right</op>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 세로 정렬" name="sb_valign" type="radio" titledirection="bk" >'.CRLF;
	$manifest .= '			<op value="top" checked="checked">Top</op>'.CRLF;
	$manifest .= '			<op value="middle">Middle</op>'.CRLF;
	$manifest .= '			<op value="bottom">Bottom</op>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 사이드바 메인 바깥여백" name="sb_mainmargin" type="text" size="20" titledirection="bk" value="8px 2px 0px 3px" >'.CRLF;
	$manifest .= '			<caption><![CDATA[<b>tip:</b> 20px 1px 2px 1px , [상px 우px 하px 좌px]]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 사이드바 서브 바깥여백" name="sb_itemmargin" type="text" size="20" titledirection="bk" value="0px 2px 5px 2px" >'.CRLF;
	$manifest .= '			<caption><![CDATA[<b>tip:</b> 20px 1px 2px 1px , [상px 우px 하px 좌px]]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 썸네일 이미지 바깥여백" name="sb_imagemargin" type="text" size="20" titledirection="bk" value="0px 0px 0px 0px" >'.CRLF;
	$manifest .= '			<caption><![CDATA[<b>tip:</b> 20px 1px 2px 1px , [상px 우px 하px 좌px]]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 썸네일 이미지 테두리 사이즈" name="sb_bordersize" type="text" size="4" titledirection="bk" value="0px" />'.CRLF;
	$manifest .= '		<field title=" : 썸네일 이미지 테두리색" name="sb_bordercolor" type="text" size="8" titledirection="bk" value="#E7E7E7" >'.CRLF;
	$manifest .= '			<caption><![CDATA[<b>tip:</b> #D7SDFS or D7SDFS, #d7sdfs or d7sdfs]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '		<field title=" : 제목.댓글.날짜 글꼴" name="sb_titlefont" type="text" size="10" titledirection="bk" value="dotum" />'.CRLF;
	$manifest .= '		<field title=" : 제목.댓글.날짜 크기" name="sb_titlesize" type="text" size="10" titledirection="bk" value="11px" />'.CRLF;
	$manifest .= '		<field title=" : 제목.댓글.날짜 색상" name="sb_titlecolor" type="text" size="10" titledirection="bk" value="#777777" >'.CRLF;
	$manifest .= '			<caption><![CDATA[<b>tip:</b> 글꼴 크기는 \'pt\', \'px\', \'em\'등 단위를 포함해야 함.]]></caption>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '	</fieldset>'.CRLF;
	$manifest .= '	<fieldset legend="사이드바 HTML Hearder">'.CRLF;
	$manifest .= '		<field title="* 사용중인 skin.html 참고" name="sb_header" cols="51" rows="6"  type="textarea" titledirection="bk" ><![CDATA[<div class="sidebar_photos">'.CRLF;
	$manifest .= '<h3>sidebar photos</h3>]]></field>'.CRLF;
	$manifest .= '	</fieldset>'.CRLF;
	$manifest .= '	<fieldset legend="사이드바 HTML Footer">'.CRLF;
	$manifest .= '		<field title="* 사용중인 skin.html 참고" name="sb_footer" cols="51" rows="6"  type="textarea" titledirection="bk" ><![CDATA[</div>]]>'.CRLF;
	$manifest .= '		</field>'.CRLF;
	$manifest .= '	</fieldset>'.CRLF;
	$manifest .= '</config>';

	return $manifest;
}

function ThumbnailDataSet($DATA){
	requireComponent('Tattertools.Function.misc');
	$cfg = misc::fetchConfigVal($DATA);
	$categories = getCategoriesSET();
	$ctArray = array(); $setCategory = array(); $pArray = array(); $fArray = array();
	foreach($categories as $category1){
		foreach($category1['children'] as $category2) array_push($ctArray, $category2['children']);
		array_push($ctArray, $category1['children']);
	}
	for($i=0; $i<=count($ctArray); $i++){
		if($cfg['c'.$i])
		array_push($setCategory, $cfg['c'.$i]);
	}
	for($j=0; $j<=3; $j++){
		if($cfg['p'.$j])
		array_push($pArray, $cfg['p'.$j]);
	}
	for($k=0; $k<=5; $k++){
		if($cfg['f'.$k])
		array_push($fArray, $cfg['f'.$k]);
	}

	if(!$cfg['call'] && count($setCategory)==0) return "::선택 오류::\n\n썸네일 카테고리는 적어도 하나이상 선택하셔야 합니다.";
	if($cfg['call']  && count($setCategory)!=0) return "::선택 오류::\n\n'All Category' 선택시 다른 카테고리는 선택할 수 없습니다.";
	if(!$cfg['call'] && count($pArray)!=0)		return "::선택 오류::\n\n'추가범위 선택'은 'All Category' 기본 선택시 함께 사용할 수 있습니다.";
	if(count($fArray)==0)						return "::선택 오류::\n\n'썸네일 적용 파일 선택'은 적어도 하나이상 선택하셔야 합니다.";

	return true;
}
?>